unit Logi;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Buttons;

type
  TForm100 = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn12: TBitBtn;
    RichEdit1: TRichEdit;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    procedure BitBtn12Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
	 procedure  Czytaj_z_pliku(fn : String);
  public
    { Public declarations }
  end;

var
  Form100: TForm100;

implementation

{$R *.dfm}

procedure TForm100.BitBtn12Click(Sender: TObject);
begin
  Close;
end;

procedure TForm100.BitBtn1Click(Sender: TObject);
begin
  RichEdit1.Clear;
  Czytaj_z_pliku('log.txt');
end;

procedure TForm100.FormActivate(Sender: TObject);
begin
  RichEdit1.Clear;
  BitBtn1.SetFocus;
end;

procedure TForm100.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 then Close;
end;




procedure TForm100.Czytaj_z_pliku(fn : String);
var
   fh : TextFile;
   s  : String;

begin
	{
	zamiast Memo.Lines.LoadFromFile(fn);
	}
   if not FileExists(fn) then
   begin
      ShowMessage('Brak pliku logw --> log.txt');
      exit;
   end;

   AssignFile(fh, fn);
   Reset(fh);

   while not Eof(fh) do
   begin
		Readln(fh, s);
//      Memo.Lines.Add(s);
     if (not CheckBox1.Checked) and (not CheckBox2.Checked) and (not CheckBox3.Checked)
        and (not CheckBox4.Checked) and (not CheckBox5.Checked) then begin
         RichEdit1.SelAttributes.Size := 10;
         if  pos(UpperCase('usunicie'),UpperCase(s)) > 0then RichEdit1.SelAttributes.Color := clRed;
         if  pos(UpperCase('zapis')    ,UpperCase(s)) > 0then RichEdit1.SelAttributes.Color := clBlue;
         RichEdit1.Lines.Add(s);
     end
     else begin
       if CheckBox1.Checked then begin
         if  pos(UpperCase('usunicie'),UpperCase(s)) > 0 then begin
           RichEdit1.SelAttributes.Color := clRed;
           RichEdit1.SelAttributes.Size := 10;
           RichEdit1.Lines.Add(s);
         end;
       end;
       if CheckBox2.Checked then begin
         if  pos(UpperCase('zapis'),UpperCase(s)) > 0 then begin
           RichEdit1.SelAttributes.Color := clBlue;
           RichEdit1.SelAttributes.Size := 10;
           RichEdit1.Lines.Add(s);
         end;
       end;
       if CheckBox3.Checked then begin
         if  pos(UpperCase('dodanie'),UpperCase(s)) > 0 then begin
           RichEdit1.SelAttributes.Size := 10;
           RichEdit1.Lines.Add(s);
         end;
       end;
       if CheckBox4.Checked then begin
         if  pos(UpperCase('uruchomienie'),UpperCase(s)) > 0 then begin
           RichEdit1.SelAttributes.Size := 10;
           RichEdit1.Lines.Add(s);
         end;
       end;
       if CheckBox5.Checked then begin
         if  pos(UpperCase('zamknicie'),UpperCase(s)) > 0 then begin
           RichEdit1.SelAttributes.Size := 10;
           RichEdit1.Lines.Add(s);
         end;
       end;
     end;
   end;
   CloseFile(fh);
end;


end.
